<?php

namespace App\Http\Requests\API\Customers;

use Illuminate\Foundation\Http\FormRequest;

class BookAppointmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'question' => 'required|string',
            'date' => 'required|date',
            'appointment_type' => 'required',
            'appointment_type_id' => 'required|exists:appointment_types,id',
            'therapist_id' => 'required_without_all:therapist_community_id|exists:therapists,id',
            'therapist_community_id' => 'required_without_all:therapist_id|exists:therapist_communitys,id',
            'appointment_schedule_id' => 'required_if:appointment_type,video,audio|exists:appointment_schedules,id',
            //'stripe_token' => 'required|string'
        ];
    }
}
